﻿using System;
using System.Data;



namespace gov.va.med.vbecs.Common
{
    /// <summary>
    /// This exception is thrown when network problems are preventing SQL queries from completing in the time alloted. Added for CR2113.
    /// </summary>
    public class SqlTimeoutException : System.Data.DataException
    {
        /// <summary>
        /// Default constructor. Error message is self-contained and cannot be changed.
        /// </summary>
        public SqlTimeoutException()
            : base(Common.StrRes.SysErrMsg.Database.DbQueryTimeout().ResString) { }

        /// <summary>
        /// This constructor allows specifying an error message upon throwing an exception.
        /// </summary>
        /// <param name="message">Human-readable message describing the error.</param>
        public SqlTimeoutException(string message)
            : base(message) { }


    }
}
